<?php

$diasdelasemana = ["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];

function validarFecha($dia, $mes, $year)
{
    if (
        (is_numeric($_POST['dia']) && is_numeric($_POST['mes']) && is_numeric($_POST['year'])) &&
        ($_POST['year'] >= 1 && $_POST['dia'] >= 1 && $_POST['dia'] <= 31 && $_POST['mes'] >= 1 && $_POST['mes'] <= 12)
    ) {
        if (
            (($mes == 1 || $mes == 3 || $mes == 5 || $mes == 7 || $mes == 8 || $mes == 10 || $mes == 12) && $dia <= 31) ||
            (($mes == 4  || $mes == 6 || $mes == 9 || $mes == 11) && $dia <= 30) ||
            ($mes == 2 && $dia <= (28 + esBisiesto($year))
            )
        ) {
            return 1;
        } else {
            return 0;
        }
    } else {
        return 0;
    }
}

function esBisiesto($year)
{
    if (($year % 4 == 0 && $year % 100 != 0) || $year % 400 == 0) {
        return 1;
    } else {
        return 0;
    }
}


function contarDias($dia, $mes, $year)
{
    if (validarFecha($dia, $mes, $year)) {
        $total = $dia;
        $meses = [31, 28 + esBisiesto($year), 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
        $year--;
        $total += $year * 365;
        $total += ($year - ($year % 4)) / 4;
        $total -= ($year - ($year % 100)) / 100;
        $total += ($year - ($year % 400)) / 400;

        for ($m = 1; $m < $mes; $m++) {
            $total += $meses[$m];
        }
        return $total;
    } else {
        return -1;
    }
}




