<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Día de la Semana</title>
</head>

<body>
    <h1>Día de la Semana</h1>
    <form action="index.php" method="post">
        <input type="number" name="dia" placeholder="Día" min="1" max="31" step="1">
        <input type="number" name="mes" placeholder="Mes" min="1" max="12" step="1">
        <input type="number" name="year" placeholder="Año" min="1" step="1">
        <input type="submit" value="Calcular">
    </form>
    <?php
    if (
        (isset($_POST['dia']) && isset($_POST['mes']) && isset($_POST['year'])) &&
        (is_numeric($_POST['dia']) && is_numeric($_POST['mes']) && is_numeric($_POST['year'])) &&
        ($_POST['year'] >= 1 && $_POST['dia'] >= 1 && $_POST['dia'] <= 31 && $_POST['mes'] >= 1 && $_POST['mes'] <= 12)
    ) {
        $esbiesto = 0; //no es bisiesto
        $dia = $_POST['dia'];
        $mes = $_POST['mes'];
        $year = $_POST['year'];
        $total = 0;
        if (($year % 4 == 0 && $year % 100 != 0) || $year % 400 == 0) {
            $esbiesto = 1; //es bisiesto
        }

        if (
            (($mes == 1 || $mes == 3 || $mes == 5 || $mes == 7 || $mes == 8 || $mes == 10 || $mes == 12) && $dia <= 31) ||
            (($mes == 4  || $mes == 6 || $mes == 9 || $mes == 11) && $dia <= 30) ||
            ($mes == 2 && $dia <= (28 + $esbiesto))
        ) {
            $total += $dia;
            $year--;
            $total += $year * 365;
            $total += ($year - ($year % 4)) / 4;
            $total -= ($year - ($year % 100)) / 100;
            $total += ($year - ($year % 400)) / 400;

            /*
            if ($mes == 2) {
                $total += 31;
            } else if ($mes == 3) {
                $total += 31 + 28 + $esbiesto;
            } else if ($mes == 4) {
                $total += 31 + 28 + $esbiesto + 31;
            } 
            */


            switch ($mes) {
                case 2:
                    $total += 31;
                    break;
                case 3:
                    $total += 31 + 28 + $esbiesto;
                    break;
                case 4:
                    $total += 31 + 28 + $esbiesto + 31;
                    break;
                case 5:
                    $total += 31 + 28 + $esbiesto + 31 + 30;
                    break;
                case 6:
                    $total += 31 + 28 + $esbiesto + 31 + 30 + 31;
                    break;
                case 7:
                    $total += 31 + 28 + $esbiesto + 31 + 30 + 31 + 30;
                    break;
                case 8:
                    $total += 31 + 28 + $esbiesto + 31 + 30 + 31 + 30 + 31;
                    break;
                case 9:
                    $total += 31 + 28 + $esbiesto + 31 + 30 + 31 + 30 + 31 + 31;
                    break;
                case 10:
                    $total += 31 + 28 + $esbiesto + 31 + 30 + 31 + 30 + 31 + 31 + 30;
                    break;
                case 11:
                    $total += 31 + 28 + $esbiesto + 31 + 30 + 31 + 30 + 31 + 31 + 30 + 31;
                    break;
                case 12:
                    $total += 31 + 28 + $esbiesto + 31 + 30 + 31 + 30 + 31 + 31 + 30 + 31 + 30;
                    break;
            }

            $resto = $total % 7;
            $year++;
            echo "<p>El {$dia}/{$mes}/{$year}: ";
            switch ($resto) {
                case 0:
                    echo "Domingo</p>";
                    break;
                case 1:
                    echo "Lunes</p>";
                    break;
                case 2:
                    echo "Martes</p>";
                    break;
                case 3:
                    echo "Miércoles</p>";
                    break;
                case 4:
                    echo "Jueves</p>";
                    break;
                case 5:
                    echo "Viernes</p>";
                    break;
                case 6:
                    echo "Sábado</p>";
                    break;
            }
        } else {
            echo "<p>La fecha no es válida</p>";
        }
    } else {
        echo "<p>Debe introducir una fecha válida</p>";
    }
    ?>
</body>

</html>