<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cajero</title>
    <link rel="stylesheet" href="style.css">
</head>

<body>

    <h1>Cajero</h1>
    <form action="index.php" method="post">
        <input type="number" name="dinero" placeholder="Dinero" min="0.01" step="0.01">
        <input type="submit" value="Sacar Dinero">
    </form>
    <main>
        <?php
        if (isset($_POST['dinero']) && is_numeric($_POST['dinero']) && $_POST['dinero'] >= 0.01) {
            $dinero = $_POST['dinero'] * 100; //el dinero en centimos
            echo "<h2>{$_POST['dinero']}€ se desgrana en: </h2>";

            echo "<ul>";
            $resto = 0;
            $cuantos = 0;

            $billetes = [500, 200, 100, 50, 20, 10, 5, 2, 1, 0.50, 0.20, 0.10, 0.05, 0.02, 0.01];

            foreach ($billetes as $key => $value) {
                $m = $value * 100;
                if ($dinero >= $m) {
                    $resto = $dinero % $m;
                    $cuantos = ($dinero - $resto) / $m;
                    echo  "<li><div>{$cuantos} X {$value}€</div><div><img src='imagenes/{$m}.jpg'></div></li>";
                    $dinero = $resto;
                }
            }
            echo "</ul>";
        }
        ?>
    </main>
</body>

</html>